/*
	Stempora Web Framework
	Copyright (c) 2002-2018 Stempora. 
	All rights reserved.
		web:  www.stempora.com
		mail: support@stempora.com				
*/

var STBGlobalConsole = Object.create(STBModule.prototype);

STBGlobalConsole.name = "ConsoleEmulator";


STBGlobalConsole.init = function() {

	var html = $("<pre/>");

	html.attr("id" , "console")
		.css({
			position		: "fixed",
			bottom			: "0",
			background		: "#ffffff",
			color			: "#000000",
//			font			: "12px Courier New",
			height			: "200",
			overflow		: "auto",
			display			: "block",
			width			: "100%",
			margin			: "0",
			padding			: "10",
			"z-index"		: "10000",
			"border-top"	: "2px solid #000000"
		});

	html.appendTo($("body"));
}


STBGlobalConsole.log = function(data) {

	//alert(data);

	var text = "";

	switch (typeof data) {

		//serialize object
		case "object":
			var acc = []
			$.each(a, function(index, value) {
				acc.push(index + ': ' + value);
			});
			text = JSON.stringify(acc);
		break;

		default: 
			text = data;
		break;	
	}


	$("#console").text($("#console").text() + "\n" + text);


	$("#console").animate({ scrollTop: $('#console').prop("scrollHeight")}, 10);
}

STBGlobalConsole.runOnReady = function() {
	STBGlobalConsole.init();
}

//site.registerModule(STBGlobalConsole);


function consoleLog(data , status) {

	if (status) {
		console.log(data);
	}	
	//STBGlobalConsole.log(data);
}